/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.api;

import filenet.vw.api.IVWtoXML;
import filenet.vw.api.VWDataField;
import filenet.vw.api.VWException;
import filenet.vw.api.VWParticipant;
import filenet.vw.api.VWQuery;
import filenet.vw.api.VWWorkElement;
import filenet.vw.server.VWField;
import filenet.vw.server.VWWorkObjectID;
import java.io.Serializable;
import java.util.Date;

public final class VWLogElement
extends VWWorkElement
implements IVWtoXML,
Serializable {
    private static final long serialVersionUID = 7497L;
    protected String FTimeStamp = "F_TimeStamp";
    protected String FSeqNumber = "F_SeqNumber";
    protected String FEventType = "F_EventType";
    protected String FWorkOrderId = "F_WorkOrderId";
    protected String FMachineId = "F_MachineId";
    protected String FDuration = "F_Duration";
    protected String FText = "F_Text";
    protected String FParentWobNum = "F_ParentWobNum";
    protected String FOperationName = "*F_Operation";

    public static String _get_FILE_DATE() {
        return "$Date: 2010-02-25 21:04:04 GMT $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author: Kevin Bentley;096657649;kbentley@us.ibm.com (kbentley) $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision: /main/PUI_460_Int/2 $";
    }

    protected VWLogElement(VWField[] fieldValues, VWWorkObjectID work_object_Id, VWQuery source) {
        super(fieldValues, work_object_Id, source);
    }

    public String[] getFieldNames() {
        return super.getFieldNames();
    }

    public String[] getAuthoredFieldNames() {
        return super.getAuthoredFieldNames();
    }

    public Object getFieldValue(String fieldName) throws VWException {
        return super.getFieldValue(fieldName);
    }

    public boolean hasField(String fieldName) throws VWException {
        return super.hasFieldName(fieldName);
    }

    public Date getTimeStamp() throws VWException {
        Object tmpval = this.getFieldValue(this.FTimeStamp);
        if (tmpval instanceof Date) {
            return (Date)tmpval;
        }
        throw new VWException("vw.api.LETimeStampNotFound", "Time Stamp not found.");
    }

    public int getSequenceNumber() throws VWException {
        Object tmpval = this.getFieldValue(this.FSeqNumber);
        if (tmpval instanceof Integer) {
            return (Integer)tmpval;
        }
        throw new VWException("vw.api.LESequenceNotFound", "Sequence Number not found.");
    }

    public String getUserName() throws VWException {
        return super.getLockedUser();
    }

    public VWParticipant getUserNamePx() throws VWException {
        return super.getLockedUserPx();
    }

    public int getEventType() throws VWException {
        Object tmpval = this.getFieldValue(this.FEventType);
        if (tmpval instanceof Integer) {
            return (Integer)tmpval;
        }
        throw new VWException("vw.api.LEEventNotFound", "Event Type not found.");
    }

    public String getWorkObjectNumber() throws VWException {
        String value = null;
        Object tmpval = this.getFieldValue("F_WobNum");
        if (tmpval instanceof String) {
            value = (String)tmpval;
        }
        return value;
    }

    public String getParentWorkObjectNumber() throws VWException {
        String value = null;
        Object tmpval = this.getFieldValue(this.FParentWobNum);
        if (tmpval instanceof String) {
            value = (String)tmpval;
        }
        if (value == null) {
            throw new VWException("vw.api.LEParentWobNumberNotFound", "Error the parent work object number is not found.");
        }
        return value;
    }

    public String getQueueName() throws VWException {
        String result = null;
        try {
            result = super.getWorkPerformerClassName();
        }
        catch (VWException vWException) {
            // empty catch block
        }
        return result;
    }

    public String getOperationName() throws VWException {
        String result = null;
        try {
            result = super.getOperationName();
        }
        catch (VWException vWException) {
            // empty catch block
        }
        return result;
    }

    public String getWorkClassName() throws VWException {
        String result = null;
        try {
            result = super.getWorkClassName();
        }
        catch (VWException vWException) {
            // empty catch block
        }
        return result;
    }

    public String getInstructionSheetName() throws VWException {
        String result = null;
        try {
            result = super.getInstructionSheetName();
        }
        catch (VWException vWException) {
            // empty catch block
        }
        return result;
    }

    public int getMachineId() throws VWException {
        Object tmpval = this.getFieldValue(this.FMachineId);
        if (tmpval instanceof Integer) {
            return (Integer)tmpval;
        }
        throw new VWException("vw.api.LELockMachineNotFound", "The machine id value is not found.");
    }

    public int getWorkOrderId() throws VWException {
        Object tmpval = this.getFieldValue(this.FWorkOrderId);
        if (tmpval instanceof Integer) {
            return (Integer)tmpval;
        }
        throw new VWException("vw.api.LEWorkOrderIdFound", "Work Order Id not found.");
    }

    public long getDuration() throws VWException {
        Object tmpval = this.getFieldValue(this.FDuration);
        if (tmpval instanceof Long) {
            return (Long)tmpval;
        }
        if (tmpval instanceof Short) {
            return ((Short)tmpval).intValue();
        }
        if (tmpval instanceof Integer) {
            return ((Integer)tmpval).intValue();
        }
        throw new VWException("vw.api.LEDurationNotFound", "Duration not found.");
    }

    public String getWorkObjectTag() throws VWException {
        return super.getTag();
    }

    public String getText() throws VWException {
        String value = null;
        Object tmpval = this.getFieldValue(this.FText);
        if (tmpval instanceof String) {
            value = (String)tmpval;
        }
        return value;
    }

    public String getWorkflowName() throws VWException {
        String result = null;
        try {
            result = super.getWorkClassName();
        }
        catch (VWException vWException) {
            // empty catch block
        }
        return result;
    }

    public String getMapName() throws VWException {
        String result = null;
        try {
            result = super.getInstructionSheetName();
        }
        catch (VWException vWException) {
            // empty catch block
        }
        return result;
    }

    public String getStepName() throws VWException {
        String value = null;
        try {
            value = super.getStepName();
        }
        catch (VWException vWException) {
            // empty catch block
        }
        return value;
    }

    public String getAuthoredStepName() throws VWException {
        String value = null;
        try {
            value = super.getAuthoredStepName();
        }
        catch (VWException vWException) {
            // empty catch block
        }
        return value;
    }

    public String toString() {
        String name = null;
        try {
            name = this.getTimeStamp().toString() + " " + new Integer(this.getSequenceNumber()).toString();
        }
        catch (VWException vWException) {
            // empty catch block
        }
        return name;
    }

    public VWDataField[] getDataFields() throws VWException {
        VWDataField[] names = super.getDataFields();
        VWDataField[] results = null;
        int cnt = 0;
        if (names != null) {
            for (int i = 0; i < names.length; ++i) {
                String name = names[i].getName();
                if (names[i] == null) continue;
                ++cnt;
            }
            if (names.length != cnt) {
                results = new VWDataField[cnt];
                int j = 0;
                for (int i = 0; i < names.length; ++i) {
                    if (names[i] == null) continue;
                    results[j] = names[i];
                    ++j;
                }
            } else {
                results = names;
            }
        }
        return results;
    }

    public VWDataField getDataField(String name) throws VWException {
        return super.getDataField(name);
    }

    public String getSelectedResponse() throws VWException {
        String value = super.getResponse();
        if (value != null) {
            return value;
        }
        return super.getSelectedResponse();
    }

    public String getSubject() throws VWException {
        return super.getSubject();
    }

    protected double getUniqueId() throws VWException {
        Object tmpval = this.getFieldValue("F_UniqueId");
        if (tmpval instanceof Double) {
            return (Double)tmpval;
        }
        throw new VWException("vw.api.LEUniqueIdNotFound", "UniqueId not found.");
    }

    int getBoundUserId() throws VWException {
        Object tmpval = this.getFieldValue("F_BoundUserId");
        if (tmpval instanceof Integer) {
            return (Integer)tmpval;
        }
        throw new VWException("vw.api.LEBoundUserIdNotFound", "Bound user not found.");
    }

    public void toXML(StringBuffer theBuffer) throws VWException {
        String ATTRIB_INDENT = "\t\t";
        if (theBuffer == null) {
            throw new VWException("vw.api.VWDataFieldNullBuffer", "buffer parameter cannot be null.");
        }
        theBuffer.append("\t<LogElement");
        theBuffer.append(">\n");
        theBuffer.append("<Fields");
        VWDataField[] df = this.getDataFields();
        if (df != null) {
            theBuffer.append(">\n");
            int arrayCount = df.length;
            for (int i = 0; i < arrayCount; ++i) {
                df[i].toXML(theBuffer);
            }
            theBuffer.append("</Fields>\n");
        } else {
            theBuffer.append("/>\n");
        }
        theBuffer.append("</LogElement>\n");
    }
}

